% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QFRM.R
\name{Opt}
\alias{Opt}
\title{\code{Opt} object constructor}
\usage{
Opt(Style = c("European", "American", "Asian", "Binary", "AverageStrike",
  "Barrier", "Chooser", "Compound", "DeferredPayment", "ForeignEquity",
  "ForwardStart", "Gap", "HolderExtendible", "Ladder", "Lookback", "MOPM",
  "Perpetual", "Quotient", "Rainbow", "Shout", "SimpleChooser", "VarianceSwap"),
  Right = c("Call", "Put", "Other"), S0 = 50, ttm = 2, K = 52,
  Curr = "$", ContrSize = 100, SName = "A stock share", SSymbol = "")
}
\arguments{
\item{Style}{An option style: \code{European} or \code{American}. Partial names are allowed, eg. \code{E} or \code{A}}

\item{Right}{An option right: \code{Call} or \code{Put}. Partial names are allowed.}

\item{S0}{A spot price of the underlying security (usually, today's stock price, \eqn{S_0})}

\item{ttm}{A time to maturity, in units of time matching r units; usually years}

\item{K}{A strike price}

\item{Curr}{An optional currency units for monetary values of the underlying security and an option}

\item{ContrSize}{A contract size, i.e. number of option shares per contract}

\item{SName}{A (optional) descriptful name of the underlying. Eg. \emph{Microsoft Corp}}

\item{SSymbol}{An (optional) official ticker of the underlying. Eg. \emph{MSFT}}
}
\value{
A list of class \code{Opt}
}
\description{
An S3 object constructor for an option contract (financial derivative)
}
\examples{
Opt()  #Creates an S3 object for an option contract
Opt(Right='Put')   #See J. C. Hull, OFOD'2014, 9-ed, Fig.13.10, p.289
}
\author{
Oleg Melnikov, Department of Statistics, Rice University, Spring 2015
}

