% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QBOS.R
\name{QBOS}
\alias{QBOS}
\title{Quantum Battle of the Sexes game}
\usage{
QBOS(p, q, moves, alpha, beta, gamma)
}
\arguments{
\item{p}{a real number between 0 and 1 including the end points}

\item{q}{a real number between 0 and 1 including the end points}

\item{moves}{alist of matrices}

\item{alpha}{a number}

\item{beta}{a number}

\item{gamma}{a number}
}
\value{
A vector consisting of the Payoffs to Alice and Bob as its two elements depending on the inputs.
}
\description{
This function returns the expected payoffs to Alice and Bob with respect to the probabilities \code{p} and \code{q}. \code{p+q} should equal 1 and \code{moves} is a list of two possible strategies for each of the players and \code{alpha, beta, gamma} are the payoffs for the players corresponding to the choices available to them with the chain of inequalities, \code{alpha>beta>gamma}.
}
\examples{
init()
moves <- list(Q$I2, sigmaX(Q$I2))
QBOS(0, 1, moves, 5, 3, 1)
QBOS(1, 1, moves, 5, 3, 1)
QBOS(0.5, 0.5, moves, 5, 3, 1)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/abs/quant-ph/0110096}\cr
}
