% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QNewcomb.R
\name{QNewcomb}
\alias{QNewcomb}
\title{Quantum Newcomb's Paradox}
\usage{
QNewcomb(Omega, probability)
}
\arguments{
\item{Omega}{|0> or |1>}

\item{probability}{a real number between 0 and 1 including the end points}
}
\value{
The final state of the quantum game as a vector along with plotting the probability densities of the qubits of the final state after measurement.
}
\description{
This function simulates the quantum version of the Newcomb's Paradox by taking in the choice of the qubit |0> or |1> by the supercomputer \code{Omega} and the probability \code{'probability'} with which Alice plays the spin flip operator. It returns the final state of the quantum game along with plotting the probability densities of the qubits of the final state after measurement.
}
\examples{
init()
QNewcomb(Q$Q0, 0)
QNewcomb(Q$Q1, 0)
QNewcomb(Q$Q1, 0.7)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0202074.pdf}\cr
}
