% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPennyFlip.R
\name{QPennyFlip}
\alias{QPennyFlip}
\title{Quantum Penny Flip game}
\usage{
QPennyFlip(initial_state, strategies_Alice, strategies_Bob)
}
\arguments{
\item{initial_state}{a vector representing the initial quantum state}

\item{strategies_Alice}{a matrix lying in SU(2)}

\item{strategies_Bob}{a matrix lying in SU(2)}
}
\value{
The final state of the game along with the plot of the probability distribution of the qubits after measurement of the final state by taking in the initial state of the game that is set by Alice and the strategies available to Alice and Bob as the inputs.
}
\description{
This function simulates the Quantum Penny Flip game by taking in the initial state of the game that is set by Alice and the strategies available to Alice and Bob. It returns the final state of the game along with the plot of the probability distribution of the qubits after measurement of the final state.
}
\examples{
init()
psi <- (u+d)/sqrt(2)
S1 <- sigmaX(Q$I2)
S2 <- Q$I2
H <- Hadamard(Q$I2)
SA <- list(S1, S2)
SB <- list(H)
QPennyFlip(psi, SA,SB)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/9804010.pdf}\cr
}
