% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crr.R
\name{crr.fit}
\alias{crr.fit}
\title{Fit A Competing Risks Regression Model}
\usage{
crr.fit(fit, cencode = 0, failcode = 1)
}
\arguments{
\item{fit}{A Cox proportional hazards regression model constructed from \code{\link[rms]{cph}} (by Frank Harrell)}

\item{cencode}{The value of the status column that indicates a censored observation}

\item{failcode}{The value of the status column that indicates the event of interest}
}
\value{
Returns a list of class \code{cmprsk}, with components:
\item{coef }{the estimated regression coefficients}
\item{loglik }{log pseudo-liklihood evaluated at coef}
\item{lscore }{derivitives of the log pseudo-likelihood evaluated at coef}
\item{inf}{-second derivatives of the log pseudo-likelihood}
\item{var}{estimated variance covariance matrix of coef}
\item{res}{matrix of residuals giving the contribution to each score
(columns) at each unique failure time (rows)}
\item{uftime}{vector of unique failure times}
\item{bfitj}{jumps in the Breslow-type estimate of the underlying
sub-distribution cumulative hazard (used by predict.crr())}
\item{tfs}{the tfs matrix (output of  tf(), if used)}
\item{converged}{TRUE if the iterative algorithm converged.}
\item{cencode }{the value of the status indicator that indicates
a censored observation}
\item{failcode}{the value of the status indicator that indicates an
event of interest}
\item{cph.f}{regular survival model fitted by cph which is saved for
function \code{nomogram.crr} to adjust lp for
competing risks}
\item{cphdat}{data used for cph model, where all
predictors are represented in numeric format, which is used by function
\code{tenf.crr} to do ten fold cross-validation}
}
\description{
Fits a competing risks regression model using the \code{\link[cmprsk]{crr}} function from an existing \code{\link[rms]{cph}}
object which can then be used to construct a nomogram.
}
\note{
This function requires that the \code{\link[rms]{rms}} package is attached
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
prostate.crr
}
\references{
Michael W. Kattan, Glenn Heller and Murray F. Brennan (2003). A
competing-risks nomogram for sarcoma-specific death following local
recurrence. Statistics in Medicine. \code{Stat Med}. 2003;22:3515-3525.
}
\seealso{
\code{\link[rms]{cph}} \code{\link[cmprsk]{crr}}
\code{nomogram.crr}
}
\author{
Michael W. Kattan, Ph.D. and Changhong Yu. Department of
Quantitative Health Sciences, Cleveland Clinic
}
\keyword{multivariate}
\keyword{survival}
