% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ploidy_est.R
\name{area_estimate_ploidy}
\alias{area_estimate_ploidy}
\title{Estimate ploidy using area method}
\usage{
area_estimate_ploidy(
  qploidy_standardization = NULL,
  samples = "all",
  level = "chromosome",
  ploidies = NULL,
  area = 0.75,
  centromeres = NULL
)
}
\arguments{
\item{qploidy_standardization}{Object of class qploidy_standardization.}

\item{samples}{If "all", all samples contained in the qploidy_standardization 
object will be evaluated. If a vector with sample names is provided, only 
those will be evaluated.}

\item{level}{Character identifying the level of the analysis. Must be one of 
"chromosome", "sample", or "chromosome-arm". If `chromosome-arm`, the 
analysis will be performed by chromosome arm (only if `centromeres` argument 
is defined).}

\item{ploidies}{Vector of ploidy levels to test. This parameter must be 
defined.}

\item{area}{Area around the expected peak to be considered. Default is 0.75.}

\item{centromeres}{Vector with centromere genomic positions in bp. The vector 
should be named with the chromosome IDs. This information will only be used 
if `chromosome-arm` level is defined.}
}
\value{
A list of class `qploidy_area_ploidy_estimation` containing:
\itemize{
  \item \code{ploidy}: Estimated ploidy by area method.
  \item \code{prop_inside_area}: Proportion of dots inside selected area.
  \item \code{diff_first_second}: Difference between first and second place in area method.
  \item \code{sd_inside_area}: Standard deviation inside area.
  \item \code{highest_correlation_modes}: Highest correlation.
  \item \code{modes_inside_area}: Modes inside areas.
  \item \code{tested}: Tested ploidies.
  \item \code{ploidy.sep}: Separated ploidy results.
  \item \code{chr}: Unique chromosomes in the dataset.
  \item \code{n.inbred}: Number of highly inbred samples.
}
}
\description{
This function estimates ploidy using the area method. It evaluates the 
number of copies by chromosome, sample, or chromosome arm. Note that this 
function does not have optimal performance, and visual inspection of the 
plots is required to confirm the estimated ploidy.
}
