% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_inputs.R
\name{simulate_illumina_file}
\alias{simulate_illumina_file}
\title{Simulate an Illumina File}
\usage{
simulate_illumina_file(
  filepath,
  num_snps = 10,
  num_samples = 1,
  sample_id_prefix = "SAMP",
  mk_id = "MK-",
  seed = 123
)
}
\arguments{
\item{filepath}{The path where the simulated Illumina file will be saved. Default is "simulated_summary.txt".}

\item{num_snps}{The number of SNPs to simulate. Default is 10.}

\item{num_samples}{The number of samples to simulate. Default is 1.}

\item{sample_id_prefix}{The prefix for sample IDs. Default is "SAMP".}

\item{mk_id}{The prefix for marker IDs. Default is "MK-".}

\item{seed}{The seed for random number generation to ensure reproducibility. Default is 123.}
}
\value{
None. The function writes the simulated Illumina file to the specified path.
}
\description{
This function generates a simulated Illumina file with SNP data for a specified number of SNPs and samples.
The file includes a header section and a data section with fields such as SNP Name, Sample ID, GC Score, Theta, X, Y, X Raw, Y Raw, and Log R Ratio.
}
\details{
The simulated data includes random values for GC Score, Theta, X, Y, X Raw, Y Raw, and Log R Ratio. The header section provides metadata about the file, including the number of SNPs and samples.
}
