% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.epid.R
\name{fit.epid}
\alias{fit.epid}
\title{Poisson log-likelihood for an observed epidemic}
\usage{
fit.epid(log.R, epid, GT, import, pred = FALSE, offset = 0)
}
\arguments{
\item{log.R}{The log-reproduction ratio.}

\item{epid}{An epidemic curve, in the sense of passing \code{\link[=check.incid]{check.incid()}} validations. It must have at least an incidence vector in an \code{incid} component.}

\item{GT}{Generation time distribution from \code{\link[=generation.time]{generation.time()}}.}

\item{import}{Vector of imported cases}

\item{pred}{Boolean. By default (\code{FALSE}), the function returns the corresponding log-likelihood. When set to \code{TRUE}, the function will return the Poisson-predicted incidence series instead.}

\item{offset}{Offset value for the log-likelihood (used to calculate confidence intervals).}
}
\value{
The Poisson log-likelihood of the observed epidemic passed as argument \code{epid},
or the Poisson-predicted incidence series given R and GT values.
}
\description{
Computes the Poisson log-likelihood of an observed epidemic, compared to the
expected incidence values for a given R and generation time distirbution.
}
\details{
For internal use. Called from \code{\link[=est.R0.ML]{est.R0.ML()}}.

Computes and returns the Poisson log-likelihood of an observed epidemic,
conditional on a given value of R and a generation time distribution.
}
\note{
This function is also used in \code{\link[=fit.epid.optim]{fit.epid.optim()}}, which is a wrapper for the
joint optimization routine to determine the best-fitting R and GT values when
the \code{\link[=est.R0.ML]{est.R0.ML()}} method is called and asked to jointly estimate reproduction
ratios and generation time distirbution.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
