% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_m.R
\name{optimize_m}
\alias{optimize_m}
\title{Optimize the m parameter during denovo stacks assembly}
\usage{
optimize_m(m3 = NULL, m4 = NULL, m5 = NULL, m6 = NULL, m7 = NULL)
}
\arguments{
\item{m3}{Path to the input vcf file for a run when m=3}

\item{m4}{Path to the input vcf file for a run when m=4}

\item{m5}{Path to the input vcf file for a run when m=5}

\item{m6}{Path to the input vcf file for a run when m=6}

\item{m7}{Path to the input vcf file for a run when m=7}
}
\value{
A list containing five summary dataframes, 'depth' showing depth per sample for each m value,
'snp' showing the number of non-missing SNPs retained in each sample at each m value, 'loci' showing the
number of non-missing loci retained in each sample at each m value, 'snp.R80' showing the total number of SNPs
retained at an 80\% completeness cutoff, and 'loci.R80' showing the total number of polymorphic loci
retained at an 80\% completeness cutoff.
}
\description{
This function requires the path to stacks vcf file(s) as input.
There are slots for varying the m parameter from 3-7 (as recommended by Paris et al. 2017).
After running stacks with each of the m options, plug the output vcf files into this
function to calculate the effect of varying m on depth and number of SNPs/loci built. Plug the output of this function into
vis_loci() to visualize the optimal the m parameter for your dataset at the 'R80' cutoff (Paris et al. 2017).
}
\examples{
optimize_m(m3=system.file("extdata","m3.vcf.gz",package="RADstackshelpR",mustWork=TRUE))
}
