% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computing-functions.R
\name{loop_redi}
\alias{loop_redi}
\title{Compute the evolution of REDI over successive inputs}
\usage{
loop_redi(data, coef = 0.1)
}
\arguments{
\item{data}{A tibble or data frame, containing an \code{Input} column (with the
Date format) and an \code{Output} column. A simple vector of workload values,
pre-sorted by chronological order can also be provided.}

\item{coef}{A number corresponding to the lambda coefficient, controlling the
decay of the exponential weights. Default is 0.1.}
}
\value{
A tibble similar to \code{data}, containing an additional \code{REDI}
column computed over the successive input values.
}
\description{
Compute the evolution of REDI over successive inputs
}
\examples{
data <- simu_db()
loop_redi(data = data, coef = 0.1)
}
