% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_esi.R
\name{calculate_esi}
\alias{calculate_esi}
\title{Calculate the Earth Similarity Index (ESI)}
\usage{
calculate_esi(..., radius_w = 0.57, flux_w = 0.7)
}
\arguments{
\item{...}{Any number of numeric parameters representing the planet's characteristics.
Parameter names should have corresponding weight names ending in \verb{_w}
(e.g., \code{mass}, \code{mass_w}).}

\item{radius_w}{Numeric. Weight for radius. Default is 0.57.}

\item{flux_w}{Numeric. Weight for stellar flux. Default is 0.7.}
}
\value{
Numeric. Earth Similarity Index (ESI).
}
\description{
Calculate the Earth Similarity Index (ESI)
}
\details{
The function calculates the ESI for any parameter or number of parameters.
By default, it uses the weights of 0.57 for radius and 0.7 for stellar flux.

ESI (Earth Similarity Index) is a characterization of how similar a planetary-mass object
or natural satellite is to Earth. It is designed to be a scale from zero to one,
with Earth having a value of 1.
}
\examples{
# ESI for radius and flux, returns 1 (Earth is perfectly similar to itself)
calculate_esi(radius = 1, flux = 1)
# Mars approximation using radius = 0.532 and flux = 0.43, returns approximately 0.754
calculate_esi(radius = 0.532, flux = 0.43)
# Custom 3-parameter ESI (e.g. radius, flux, temperature)
calculate_esi(radius = 1.1, flux = 1.2, temp = 288,
              radius_w = 0.5, flux_w = 0.3, temp_w = 0.2)

}
\references{
Schulze-Makuch, D., Méndez, A., Fairén, A. G., von Paris, P., Turse, C., Boyer, G.,
Davila, A. F., Resendes de Sousa António, M., Irwin, L. N., and Catling, D. (2011)
A Two-Tiered Approach to Assess the Habitability of Exoplanets. Astrobiology 11(10): 1041-1052.
}
