% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omega.R
\name{omega}
\alias{omega}
\title{This function finds the bivariate joint probability or the binary correlation from the corresponding Gaussian correlation \code{x}}
\usage{
omega(x = 0.5, p0_v1 = 0.5, p0_v2 = NA, correlation = FALSE)
}
\arguments{
\item{x}{value of expected correlation between the corresponding Gaussian-distributed variables}

\item{p0_v1, p0_v2}{probability of no precipitation occurrences for the v1 and v2 time series respectively. See \code{Notes}.}

\item{correlation}{logical numeric value. Default is \code{FALSE}. If \code{TRUE} the function returns the binary correlation like eq. 6 of Mhanna, et al.,2011.}
}
\value{
probability of no precipitation occurrence in both v1 and v2 simultaneously. It is a matrix if \code{x} is a matrix.
}
\description{
This function finds the bivariate joint probability or the binary correlation from the corresponding Gaussian correlation \code{x}
}
\note{
This function makes use of normal copula. A graphical introduction to this function (with its inverse) makes is present in Mhanna and Bauwens (2011)
  and Wilks (1988) (See fig. 1 and par. 3.2) 
If the argument \code{p0_v2}, the two marginal probability values must be given as a vector through the  argument \code{p0_v1}: \code{p0_v1=c(p0_v1,p0_v2)} . 
In case \code{x} is a correlation/covariance matrix the marginal probabilities are given as a vector through the argument \code{p0_v1}.
}
\examples{
rho <- 0.4
p00 <- omega(x=rho,p0_v1=0.5,p0_v2=0.5)
cor00 <- omega(x=rho,p0_v1=0.5,p0_v2=0.5,correlation=TRUE)
}
\references{
D.S. Wilks (1998), Multisite Generalization of a Daily Stochastic Precipitation Generation Model, Journal of Hydrology, Volume 210, Issues 1-4, September 1998, Pages 178-191,
\doi{10.1016/S0022-1694(98)00186-3} , 

Muamaraldin Mhanna and Willy Bauwens (2011) A Stochastic Space-Time Model for the Generation of Daily Rainfall in the Gaza Strip, International Journal of Climatology, Volume 32, Issue 7, pages 1098-1112,
\doi{10.1002/joc.2305}, https://rmets.onlinelibrary.wiley.com/doi/10.1002/joc.2305
}
\seealso{
\code{\link[copula]{normalCopula}},\code{\link[copula]{pcopula}}
}
\author{
Emanuele Cordano
}
