% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAFSI.R
\name{apply.RAFSI}
\alias{apply.RAFSI}
\title{Ranking of Alternatives through Functional mapping of criterion sub-intervals
into a Single Interval (RAFSI)}
\usage{
apply.RAFSI(
  mat,
  weights,
  beneficial.vector,
  ideal = NULL,
  anti_ideal = NULL,
  n_i = 1,
  n_k = 6
)
}
\arguments{
\item{mat}{A numeric matrix or data frame with rows = alternatives, columns = criteria}

\item{weights}{A numeric vector of weights (one per criterion)}

\item{beneficial.vector}{A numeric vector that stores the column indices of all beneficial
(i.e., "max") criteria. Columns not in \code{beneficial.vector} are treated as "min".}

\item{ideal}{A numeric vector of ideal values for each criterion (optional)}

\item{anti_ideal}{A numeric vector of anti-ideal values for each criterion (optional)}

\item{n_i}{Lower bound in the functional mapping (default = 1)}

\item{n_k}{Upper bound in the functional mapping (default = 6)}
}
\value{
A numeric vector of final RAFSI scores, one per row of \code{mat}.
}
\description{
Ranking of Alternatives through Functional mapping of criterion sub-intervals
into a Single Interval (RAFSI)
}
\examples{
mat <- matrix(c(3, 2, 5,
4, 3, 2,
1, 6, 4),
nrow = 3, byrow = TRUE)
weights <- c(0.3, 0.5, 0.2)
beneficial.vector <- c(1, 2)
apply.RAFSI(mat, weights, beneficial.vector,   n_i = 1, n_k = 6)
}
