% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkt_ecdf.R
\name{rkt_ecdf}
\alias{rkt_ecdf}
\alias{print.rkt_ecdf}
\alias{mean.rkt_ecdf}
\alias{variance.rkt_ecdf}
\alias{plot.rkt_ecdf}
\title{Empirical estimate of the CDF}
\usage{
rkt_ecdf(x, w)

\method{print}{rkt_ecdf}(x, ...)

\method{mean}{rkt_ecdf}(x, ...)

\method{variance}{rkt_ecdf}(x, ...)

\method{plot}{rkt_ecdf}(x, ...)
}
\arguments{
\item{x}{Numeric vector containing the sample. Alternatively, if \code{w} is supplied, distinct values within the sample. For S3 methods, a function of class \code{rkt_ecdf}.}

\item{w}{Optional. Numeric vector containing the weights of each value in \code{x}.}

\item{...}{Further parameters.}
}
\value{
A function of class \code{rkt_ecdf}.
}
\description{
Calculate an empirical cumulative distribution function based on a sample \code{x} and optionally a vector \code{w} of weights.
}
\details{
The weights vector \code{w} can contain the counts of each distinct value in \code{x}, this is the most natural use case. 
In general the weights are describing the jumps of the final ecdf. Normalization is handled internally.

If \code{x} contains duplicates, corresponding values in \code{w} will be summed up.
Only positive weights are allowed. Elements in \code{x} with non-positive weights will be ignored.
}
\examples{
require(ROCket)

plot(rkt_ecdf(rnorm(100)))
plot(rkt_ecdf(c(0, 1)))
plot(rkt_ecdf(c(0, 1), c(1, 10)))
}
