% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_areas.R
\name{pauc}
\alias{pauc}
\title{Calculate partial area under curve}
\usage{
pauc(
  data = NULL,
  response,
  predictor,
  ratio,
  lower_threshold,
  upper_threshold,
  .condition = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{ratio}{Ratio or axis where to apply calculations.
\itemize{
\item If \code{"tpr"}, only points within the specified region of TPR, y axis, will be
considered for calculations.
\item If \code{"fpr"}, only points within the specified region of FPR, x axis, will be
considered for calculations.
}}

\item{lower_threshold, upper_threshold}{Two numbers between 0 and 1,
inclusive.
These numbers represent lower and upper bounds of the region where to
apply calculations.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}
}
\value{
A numeric value representing the area under ROC curve in the specified
region.
}
\description{
Calculates area under curve curve in an specific TPR or FPR region.
}
\examples{
# Calculate pauc of Sepal.Width as a classifier of setosa species in
# in TPR = (0.9, 1)
pauc(
  iris,
  response = Species,
  predictor = Sepal.Width,
  ratio = "tpr",
  lower_threshold = 0.9,
  upper_threshold = 1
)
# Calculate pauc of Sepal.Width as a classifier of setosa species in
# in FPR = (0, 0.1)
pauc(
  iris,
  response = Species,
  predictor = Sepal.Width,
  ratio = "fpr",
  lower_threshold = 0,
  upper_threshold = 0.1
)
}
