% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenWeatherMap.R
\name{get_multiple_cities}
\alias{get_multiple_cities}
\title{get current weather data for multiple cities}
\usage{
get_multiple_cities(api_key, bbox = NA, coordinates = NA, count = NA,
  cityIDs = NA, cluster = "yes", units = "metric")
}
\arguments{
\item{api_key}{Open weather map API key}

\item{bbox}{bounding box [lat of the top left point, lon of the top left point, lat of the bottom right point, lon of the bottom right point, map zoom]}

\item{coordinates}{(lat,lon) coordinates of the location of your interest}

\item{count}{number of cities around the point that should be returned}

\item{cityIDs}{city IDs}

\item{cluster}{use server clustering of points. Possible values are [yes, no]}

\item{units}{metric units}

}
\value{
data frame giving current weather data for several locations
}
\description{
get current weather data for multiple cities
}
\examples{
\dontrun{
data=get_multiple_cities(api_key,cityIDs =c(524901,703448,2643743))
}
}

