% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.rsaSIM.R
\name{plotting.rsaSIM}
\alias{plotting.rsaSIM}
\title{Plots the response surface of a simulated polynomial model}
\usage{
plotting.rsaSIM(
  int = 0,
  x,
  y,
  x2,
  xy,
  y2,
  x3,
  x2y,
  xy2,
  y3,
  corr_xy = 0,
  e_label = NULL,
  center = "variablewise",
  scale = "variablewise",
  seed = 123,
  type = "3d",
  model = c("CUBIC", "QUADRATIC", "FM3_ADDITIVE"),
  acceleration = c(0, 0),
  FAST = TRUE,
  n_sample = 10000,
  xlim = c(-3, 3),
  ylim = c(-3, 3),
  zlim = c(-3, 3),
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  main = "",
  surface = "predict",
  lambda = NULL,
  suppress.surface = FALSE,
  suppress.box = FALSE,
  suppress.grid = FALSE,
  suppress.ticklabels = FALSE,
  rotation = list(x = -63, y = 32, z = 15),
  label.rotation = list(x = 19, y = -40, z = 92),
  gridsize = 21,
  bw = FALSE,
  legend = TRUE,
  param = TRUE,
  coefs = FALSE,
  axes = c("LOC", "LOIC", "r1_LOC", "r2_LOC", "r1_LOIC", "r2_LOIC", "a1_LOC", "a2_LOC",
    "a1_LOIC", "a2_LOIC"),
  axesStyles = list(LOC = list(lty = "solid", lwd = 2, col = ifelse(bw == TRUE,
    "black", "blue")), LOIC = list(lty = "solid", lwd = 2, col = ifelse(bw == TRUE,
    "black", "blue")), PA1 = list(lty = "dotted", lwd = 2, col = ifelse(bw == TRUE,
    "black", "gray30")), PA2 = list(lty = "dotted", lwd = 2, col = ifelse(bw == TRUE,
    "black", "gray30")), r1_LOC = list(lty = "solid", lwd = 2, col = ifelse(bw == TRUE,
    "black", "green")), r2_LOC = list(lty = "solid", lwd = 2, col = ifelse(bw == TRUE,
    "black", "green")), r1_LOIC = list(lty = "solid",      lwd = 2, col = ifelse(bw ==
    TRUE, "black", "red")), r2_LOIC = list(lty = "solid", lwd = 2, col = ifelse(bw ==
    TRUE, "black", "red")), a1_LOC = list(lty = "twodash", lwd = 2, col = ifelse(bw ==
    TRUE, "black", "green")), a2_LOC = list(lty = "twodash", lwd = 2, col = ifelse(bw ==
    TRUE, "black", "green")), a1_LOIC = list(lty = "twodash", lwd = 2, col = ifelse(bw ==
    TRUE, "black", "red")), a2_LOIC = list(lty = "twodash", lwd = 2, col = ifelse(bw ==
    TRUE, "black", "red"))),
  project = c("contour"),
  maxlines = FALSE,
  cex.tickLabel = 1,
  cex.axesLabel = 1,
  cex.main = 1,
  points = list(jitter = 0.1, show = T, value = "predicted"),
  fit = NULL,
  link = "identity",
  tck = c(1.5, 1.5, 1.5),
  distance = c(1.3, 1.3, 1.4),
  border = FALSE,
  contour = list(show = FALSE, color = "grey40", highlight = c()),
  hull = NA,
  showSP = FALSE,
  showSP.CI = FALSE,
  pal = NULL,
  pal.range = "box",
  pad = 0,
  claxes.alpha = 0.05,
  demo = FALSE,
  ...
)
}
\arguments{
\item{int}{Intercept (b0)}

\item{x}{X coefficient (b1)}

\item{y}{Y coefficient (b2)}

\item{x2}{X^2 coefficient (b3)}

\item{xy}{XY interaction coefficient (b4)}

\item{y2}{Y^2 coefficient (b5)}

\item{x3}{X^3 coefficient (b9)}

\item{x2y}{X^2Y coefficient (b7)}

\item{xy2}{XY^2 coefficient (b8)}

\item{y3}{Y^3 coefficient (b6)}

\item{corr_xy}{Correlation between predictors (default to 0).}

\item{e_label}{If "none", no extrema coordinates are projected. Defaults to NULL.}

\item{center}{Method for centering the predictor variables before the analysis. Default option ("variablewise") centers the predictor variables on \emph{their respective} sample mean. "none" applies no centering. "pooled" centers the predictor variables on their \emph{pooled} sample mean. You should think carefully before applying the "pooled" option, as centering or reducing the predictor variables on common values (e.g., their grand means and SDs) can affect the commensurability of the predictor scales.}

\item{scale}{Method for scaling the predictor variables before the analysis. Default option ("variablewise") scales the predictor variables on \emph{their respective} sample SD. "none" applies no scaling. "pooled" scales the predictor variables on their \emph{pooled} sample SD. You should think carefully before applying the "pooled" option, as scaling the predictor variables on common values (e.g., their grand SDs) can affect the commensurability of the predictor scales.}

\item{seed}{Randomization seed for reproducible results}

\item{type}{\code{3d} for 3d surface plot, \code{2d} for 2d contour plot, "interactive" for interactive rotatable plot.}

\item{model}{If x is an RSA object: from which model should the response surface be computed?}

\item{acceleration}{Rates of accelerations along the LOC and LOIC to be inspected (0< |rate| < 1). Passed on internally to \code{ident.ext}}

\item{FAST}{If FALSE, will also project response over LOC and LOIC. If TRUE, will only project the response surface (faster option).}

\item{n_sample}{Size of simulated sample}

\item{xlim}{Limits of the x axis}

\item{ylim}{Limits of the y axis}

\item{zlim}{Limits of the z axis}

\item{xlab}{Label for x axis}

\item{ylab}{Label for y axis}

\item{zlab}{Label for z axis}

\item{main}{the main title of the plot}

\item{surface}{Method for the calculation of the surface z values. "predict" takes the predicted values from the model, "smooth" uses a thin plate smoother (function \code{Tps} from the \code{fields} package) of the raw data}

\item{lambda}{lambda parameter for the smoother. Default (NULL) means that it is estimated by the smoother function. Small lambdas around 1 lead to rugged surfaces, big lambdas to very smooth surfaces.}

\item{suppress.surface}{Should the surface be suppressed (only for \code{type="3d"})? Useful for only showing the data points, or for didactic purposes (e.g., first show the cube, then fade in the surface).}

\item{suppress.box}{Should the surrounding box be suppressed (only for \code{type="3d"})?}

\item{suppress.grid}{Should the grid lines be suppressed (only for \code{type="3d"})?}

\item{suppress.ticklabels}{Should the numbers on the axes be suppressed (only for \code{type="3d"})?}

\item{rotation}{Rotation of the 3d surface plot (when type == "3d")}

\item{label.rotation}{Rotation of the axis labls (when type == "3d")}

\item{gridsize}{Number of grid nodes in each dimension}

\item{bw}{Print surface in black and white instead of colors?}

\item{legend}{Print color legend for z values?}

\item{param}{Should the surface parameters a1 to a5 be shown on the plot? In case of a 3d plot a1 to a5 are printed on top of the plot; in case of a contour plot the principal axes are plotted. Surface parameters are not printed for cubic surfaces.}

\item{coefs}{Should the regression coefficients b1 to b5 (b1 to b9 for cubic models) be shown on the plot? (Only for 3d plot)}

\item{axes}{*A vector of strings specifying the axes that should be plotted. Can be any combination of c("LOC", "LOIC","r1_LOC","r2_LOC","r1_LOIC","r2_LOIC","a1_LOC","a2_LOC","a1_LOIC","a2_LOIC"). LOC = line of congruence, LOIC = line of incongruence, r1_LOC = first reversal point on LOC,r2_LOC = second reversal point on LOC,r1_LOIC = first reversal point on LOIC,r2_LOIC = second reversal point on LOIC,a1_LOC = first acceleration point on LOC,a2_LOC = second acceleration point on LOC,a1_LOIC = first acceleration point on LOIC,a2_LOIC = second acceleration point on LOIC.}

\item{axesStyles}{*Define the visual styles of the axes LOC,LOIC,r1_LOC,r2_LOC,r1_LOIC,r2_LOIC,a1_LOC,a2_LOC,a1_LOIC,a2_LOIC. Provide a named list: \code{axesStyles=list(LOC = list(lty="solid",  lwd=2, col=ifelse(bw==TRUE, "black", "blue"))}. It recognizes three parameters: \code{lty}, \code{lwd}, and \code{col}. If you define a style for an axis, you have to provide all three parameters, otherwise a warning will be shown.}

\item{project}{*A vector of graphic elements that should be projected on the floor of the cube. Can include any combination of c("LOC", "LOIC", "contour", "points"). Note that projected elements are plotted in the order given in the vector (first elements are plotted first and overplotted by later elements).}

\item{maxlines}{Should the maximum lines be plotted? (red: maximum X for a given Y, blue: maximum Y for a given X). Works only in type="3d"}

\item{cex.tickLabel}{Font size factor for tick labels}

\item{cex.axesLabel}{Font size factor for axes labels}

\item{cex.main}{Factor for main title size}

\item{points}{A list of parameters which define the appearance of the raw scatter points: 
\itemize{
    \item data: Data frame which contains the coordinates of the raw data points. First column = x, second = y, third = z. This data frame is automatically generated when the plot is based on a fitted RSA-object
    \item n_random *Number of randomly drawn data points to be plotted from data. Used to avoid cluttering in large datasets.
    \item show = TRUE: Should the original data points be overplotted?
    \item color = "black": Color of the points. Either a single value for all points, or a vector with the same size as data points provided. If parameter \code{fill} is also defined, \code{color} refers to the border of the points.
    \item fill = NULL: Fill of the points. Either a single value for all points, or a vector with the same size as data points provided. As a default, this is set to NULL, which means that all points simply have the color \code{color}.
        \item value="raw": Plot the original z value, "predicted": plot the predicted z value
    \item jitter = 0: Amount of jitter for the raw data points. For z values, a value of 0.005 is reasonable
    \item cex = .5: multiplication factor for point size. Either a single value for all points, or a vector with the same size as data points provided.
        \item stilt: Should stilts be drawn for selected data points (i.e., lines from raw data points to the floor)? A logical vector with the same size as data points provided, indicating which points should get a stilt.
        \item out.mark = FALSE: If set to TRUE, outliers according to Bollen & Jackman (1980) are printed as red X symbols, but only when they have been removed in the RSA function: \code{RSAmodel(..., out.rm=TRUE)}.
        \itemize{
            \item If out.rm == TRUE (in RSAmodel()) and out.mark == FALSE (in plotting.rsa()), the outlier is removed from the model and *not plotted* in RSAplot.
            \item If out.rm == TRUE (in RSAmodel()) and out.mark == TRUE (in plotting.rsa()), the outlier is removed from the model but plotted and marked in RSAplot.
            \item If out.rm == FALSE (in RSAmodel()): Outliers are not removed and cannot be plotted.
            \item Example syntax: \code{plotting.rsa(r1, points=list(show=TRUE, out.mark=TRUE))}
    }
}
As a shortcut, you can also set \code{points=TRUE} to set the defaults.}

\item{fit}{Do not change that parameter (internal use only)}

\item{link}{Link function to transform the z axes. Implemented are "identity" (no transformation; default), "probit", and "logit"}

\item{tck}{A vector of three values defining the position of labels to the axes (see ?wireframe)}

\item{distance}{A vector of three values defining the distance of labels to the axes}

\item{border}{Should a thicker border around the surface be plotted? Sometimes this border leaves the surrounding box, which does not look good. In this case the border can be suppressed by setting \code{border=FALSE}.}

\item{contour}{A list defining the appearance of contour lines (aka. height lines). show=TRUE: Should the contour lines be plotted on the 3d wireframe plot? (Parameter only relevant for \code{type="3d"}). color = "grey40": Color of the contour lines. highlight = c(): A vector of heights which should be highlighted (i.e., printed in bold). Be careful: the highlighted line is not necessarily exactly at the specified height; instead the nearest height line is selected.}

\item{hull}{Plot a bag plot on the surface (This is a bivariate extension of the boxplot. 50\% of points are in the inner bag, 50\% in the outer region). See Rousseeuw, Ruts, & Tukey (1999).}

\item{showSP}{Plot the stationary point? (only relevant for \code{type="contour"})}

\item{showSP.CI}{Plot the CI of the stationary point? (only relevant for \code{type="contour"})}

\item{pal}{A palette for shading.}

\item{pal.range}{Should the color range be scaled to the box (\code{pal.range = "box"}, default), or to the min and max of the surface (\code{pal.range = "surface"})? If set to "box", different surface plots can be compared along their color, as long as the zlim is the same for both.}

\item{pad}{Pad controls the margin around the figure (positive numbers: larger margin, negative numbers: smaller margin)}

\item{claxes.alpha}{Alpha level that is used to determine the axes K1 and K2 that demarcate the regions of significance for the cubic models "CL" and "RRCL"}

\item{demo}{Do not change that parameter (internal use only)}

\item{...}{Additional parameters passed to the plotting function (e.g., sub="Title"). A useful title might be the R squared of the plotted model: \code{sub = as.expression(bquote(R^2==.(round(getPar(x, "r2", model="CUBIC"), 3))))}}
}
\value{
A plot of the simulated response surface
}
\description{
Plots the response surface of a model based on simulation parameter values.
}
\details{
Based on polynomial parameters provided by the user, this function simulates data and plots the corresponding response surface, including reversals and accelerations (when applicable).
}
\examples{
######SIMULATE RESPONSE SURFACE OF A MODEL FM26_PARALLELASYMWEAK (b9=1/3*b8)
###### WITH COR(X,Y)=.20
##Define polynomial parameters and correlation
b0 <- 0
b1 <- -0.064
b2 <- -b1*6
b3 <- -0.058
b5 <- b3*0.7
b4 <- 0
b6 <- 0
b7 <- 0
b8 <- -0.10
b9 <- 1/3*b8
corrXY <- 0.20
##Simulate corresponding surface
plotSIM <- plotting.rsaSIM(x=b1,y=b2,x2=b3,xy=b4,y2=b5,x3=b6,x2y=b7,xy2=b8,y3=b9,corr_xy= corrXY)
plotSIM 
}
\references{
Rousseeuw, P. J., Ruts, I., & Tukey, J. W. (1999). The Bagplot: A Bivariate Boxplot. The American Statistician, 53(4), 382-387. doi:10.1080/00031305.1999.10474494
 
Núñez-Regueiro, F., Juhel, J. (2022). \emph{Model-Building Strategies in Response Surface Analysis} Manuscript submitted for publication.
 
Núñez-Regueiro, F., Juhel, J. (2024a). \emph{Response Surface Analysis for the Social Sciences I: Identifying Best-Fitting Polynomial Solutions} Manuscript submitted for publication.
 
Núñez-Regueiro, F., Juhel, J. (2024b). \emph{Response Surface Analysis for the Social Sciences II: Combinatory Rationales for Complex Polynomial Models} Manuscript submitted for publication.
}
\seealso{
\code{\link{plotting.ext}}, \code{\link{RSAmodel}}
}
