#' Complete list of palettes.
#'
#' Use \code{names(RSSPalettes)} to return all palette names.
#'
#' @export
RSSPalettes <- list(
  signif_seq = list(c(
    "#163B13", "#20551B", "#2A7024",
    "#348A2C", "#3FA535", "#5DB355",
    "#7CC175", "#9BD095", "#B9DEB6"
  )),
  signif_div = list(c(
    "#E41B12", "#EB5751", "#F29490",
    "#F9D1CF", "#FFFFFF", "#CCEBF3",
    "#88D0E3", "#43B6D3", "#009CC4"
  )),
  signif_qual = list(c("#3fa535", "#f4c100", "#009cc4", "#f07d00"))
)

#' Significance red hex colour
#' @export
signif_red <- "#e41b12"

#' Significance yellow hex colour
#' @export
signif_yellow <- "#f4c100"

#' Significance blue hex colour
#' @export
signif_blue <- "#009cc4"

#' Significance orange hex colour
#' @export
signif_orange <- "#f07d00"

#' Significance green hex colour
#' @export
signif_green <- "#3fa535"
