% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{pfree.calc}
\alias{pfree.calc}
\title{Probability of freedom over time}
\usage{
pfree.calc(sep, p.intro, prior = 0.5, discount.1 = TRUE)
}
\arguments{
\item{sep}{population sensitivity for each time period (vector)}

\item{p.intro}{probability of introduction for each time period (scalar
or vector of same length as sep)}

\item{prior}{prior probability of freedom before surveillance (scalar)}

\item{discount.1}{logical variable whether or not to discount first time period.}
}
\value{
\code{data.frame} with columns for sep, p.intro, discounted
  prior, probability of freedom, equilibrium probability of freedom
  and equilibrium prior
}
\description{
Calculates the probability (confidence) of disease freedom for
given prior, sep and p.intro over 1 or more time periods
}
\examples{
# examples for pfree.calc
pfree.calc(0.8, 0.01, 0.5)
pfree.calc(0.8, 0.01, 0.5, FALSE)
pfree.calc(rep(0.6,24), 0.01, 0.5)
pfree.calc(rep(0.6,24), 0.01, 0.5, FALSE)
pfree.calc(runif(10, 0.4, 0.6), 0.01, 0.5)
pfree.calc(runif(10, 0.4, 0.6), runif(10, 0.005, 0.015), 0.5)
}
\keyword{methods}
