% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_based_functions.R
\name{sep.rb2.binom}
\alias{sep.rb2.binom}
\title{Binomial risk-based population sensitivity for 2 risk factors}
\usage{
sep.rb2.binom(pstar, rr1, ppr1, rr2, ppr2, n, se)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr1}{relative risks for first level risk factor (vector of values corresponding 
to the number of risk strata)}

\item{ppr1}{population proportions for first level risk factor (vector of
same length as rr1)}

\item{rr2}{relative risks for second level risk factor, 
matrix, rows = levels of rr1, cols = levels of rr2}

\item{ppr2}{population proportions for second level 
risk factor, matrix, rows = levels of rr1, cols = levels of rr2}

\item{n}{matrix of number tested for each risk group 
(rows = levels of rr1, cols = levels of rr2)}

\item{se}{test unit sensitivity (scalar)}
}
\value{
list of 4 elements, a scalar of population-level sensitivity
  a matrix of EPI values, a vector of corresponding Adjusted risks for
  the first risk factor and a matrix of adjusted risks for the second 
  risk factor
}
\description{
Calculates risk-based population sensitivity for 
  two risk factors, using binomial method (assumes a large population)
}
\examples{
# examples for sep.rb2.binom
pstar<- 0.01
rr1<- c(3, 1)
ppr1<- c(0.2, 0.8)
rr2<- rbind(c(4,1), c(4,1))
ppr2<- rbind(c(0.1, 0.9), c(0.3, 0.7))
se<- 0.8
n<- rbind(c(50, 20), c(20, 10))
sep.rb2.binom(pstar, rr1, ppr1, rr2, ppr2, n, se)
}
\keyword{methods}
