% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00roxygen.R, R/sim.R
\name{Simulation}
\alias{Simulation}
\alias{simref}
\alias{dim<-.simref}
\alias{length.simref}
\alias{dim.simref}
\alias{is.array.simref}
\alias{is.matrix.simref}
\alias{as.array.simref}
\alias{is.na.simref}
\alias{[.simref}
\alias{[<-.simref}
\alias{Ops.simref}
\alias{Math.simref}
\alias{t.simref}
\alias{diff.simref}
\alias{Summary.simref}
\title{Simulation}
\usage{
simref(n)

\method{dim}{simref}(x) <- value

\method{length}{simref}(x)

\method{dim}{simref}(x)

\method{is.array}{simref}(x)

\method{is.matrix}{simref}(x)

\method{as.array}{simref}(x, ...)

\method{is.na}{simref}(x)

\method{[}{simref}(x, ...)

\method{[}{simref}(x, ...) <- value

\method{Ops}{simref}(e1, e2)

\method{Math}{simref}(x, ...)

\method{t}{simref}(x)

\method{diff}{simref}(x, lag = 1L, differences = 1L, ...)

\method{Summary}{simref}(..., na.rm = FALSE)
}
\arguments{
\item{n}{Length}

\item{x}{Object of class 'simref'}

\item{value}{Replacement (numeric)}

\item{...}{Extra arguments}

\item{e1}{First argument}

\item{e2}{Second argument}

\item{lag}{As \link[base]{diff}}

\item{differences}{As \link[base]{diff}}

\item{na.rm}{Ignored}
}
\value{
An object with write access to store the simulation.
}
\description{
An RTMB objective function can be run in 'simulation mode' where standard likelihood evaluation is replaced by corresponding random number generation. This facilitates automatic simulation under some restrictions, notably regarding the \emph{order of likelihood accumulation} in the user template - see details. Simulations can be obtained directly from the model object by \code{obj$simulate()} or used indirectly via \link{checkConsistency}.
In both cases a simulation is carried out from the \emph{full} model i.e. both \emph{random effects} and \emph{observations} are simulated. The \link{OBS} function is used to mark which data items are observations - see examples.
}
\details{
In simulation mode all log density evaluation, involving either random effects or observations, is interpreted as probability assignment.

\bold{direct vs indirect} Assignments can be 'direct' as for example

\code{dnorm(u, log=TRUE)      ## u ~ N(0, 1)}

or 'indirect' as in

\code{dnorm(2*(u+1), log=TRUE)  ## u ~ N(-1, .25)}

Indirect assignment works for a limited set of easily invertible functions - see \code{methods(class="simref")}.

\bold{Simulation order} Note that probability assignments are sequential: All information required to draw a new variable must already be simulated. It follows that, for the simulation to work, one cannot assume likelihood accumulation is commutative!

Vectorized assignment implicitly occurs elementwise from left to right.
For example the assignment

\code{dnorm(diff(u), log=TRUE)}

is not valid without a prior assignment of \code{u[1]}, e.g.

\code{dnorm(u[1], log=TRUE)}

\bold{Supported distributions} Assignment must use supported density functions. I.e.

\code{dpois(N, exp(u), log=TRUE)}

cannot be replaced by

\code{N * u - exp(u)}

The latter will have no effect in simulation mode (the simulation will be \code{NA}).

\bold{Return value} Note that when in simulation mode, the density functions all return zero. The actual simulation is written to the input argument by reference. This is very unlike standard R semantics.
}
\section{Functions}{
\itemize{
\item \code{simref()}: Construct \code{simref}

\item \code{dim(simref) <- value}: Equivalent of \link[base]{dim<-}

\item \code{length(simref)}: Equivalent of \link[base]{length}

\item \code{dim(simref)}: Equivalent of \link[base]{dim}

\item \code{is.array(simref)}: Equivalent of \link[base]{is.array}

\item \code{is.matrix(simref)}: Equivalent of \link[base]{is.matrix}

\item \code{as.array(simref)}: Equivalent of \link[base]{as.array}

\item \code{is.na(simref)}: Equivalent of \link[base]{is.na}

\item \code{[}: Equivalent of \link[base]{[}

\item \code{`[`(simref) <- value}: Equivalent of \link[base]{[<-}

\item \code{Ops(simref)}: Equivalent of \link[base]{Ops}

\item \code{Math(simref)}: Equivalent of \link[base]{Math}

\item \code{t(simref)}: Equivalent of \link[base]{t}

\item \code{diff(simref)}: Equivalent of \link[base]{diff}

\item \code{Summary(simref)}: \link{Summary} operations are not invertible and will throw an error.

}}
\examples{
## Basic example simulating response marked by OBS()
func <- function(par) {
  getAll(par, tmbdata)
  y <- OBS(y)
  ans <- -sum(dbinom(y, prob = plogis(a+b*x), size = 1, log = TRUE))
}
set.seed(101)
tmbdata <- list(x = seq(-3, 3, length = 25))
tmbdata$y <- rbinom(25, size = 1, prob = plogis(2 - 0.1*tmbdata$x))
obj <- MakeADFun(func, list(a = 0, b = 0), silent=TRUE)
with(obj, nlminb(par, fn, gr))
obj$simulate()
## Basic example simulating random effects
func <- function(p) {
  u <- p$u
  ans <- -dnorm(u[1], log=TRUE) ## u[1] ~ N(0,1)
  ans <- ans - sum(dnorm(diff(u), log=TRUE)) ## u[i]-u[i-1] ~ N(0,1)
}
obj <- MakeADFun(func, list(u=numeric(20)), random="u")
obj$simulate()
## Demonstrate how a 'simref' object works
s <- simref(4)
s2 <- 2 * s[1:2] + 1
s2[] <- 7
s ## 3 3 NA NA
}
