% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{helperTrapezoidRule}
\alias{helperTrapezoidRule}
\title{Helper function to compute the integrals in each interval.}
\usage{
helperTrapezoidRule(densitiesVec)
}
\arguments{
\item{densitiesVec}{the vector of values to be integrated}
}
\value{
a vector in which each index i is the integral in the interval
(0, p[[i]]). Consequently, the first element in the vector returned
will be 0, since p[[1]] = 0 does not exist.
}
\description{
Computes a vector in which each index i is the integral in the interval (0, p[[i]])
of the function described by the densityVec
Uses the trapezoidal rule # https://en.wikipedia.org/wiki/Trapezoidal_rule
to integrate the values in the interval [0,1]. The x corexponding to the
values (the f(x)) are assumed to be equidistantly distributed in the interval,
where the x corresponding to densitiesVec[[1]] is located in 0.0 andthe x
corresponding to densitiesVec[[length(densitiesVec)]] is located in 1.0
}
\examples{
### Example 1 ###
helperTrapezoidRule(c(1,2,3,3,3,4,5,9,3,0,1))
# 0.00 0.15 0.40 0.70 1.00 1.35 1.80 2.50 3.10 3.25 3.30
}
\keyword{internal}
