#' Clients' information for a small example
#'
#' A dataset containing information about 20 clients of a certain bank.
#'
#' \itemize{
#'   \item age, numeric. Age of the client in years.
#'   \item antiquity_age, numeric. Age of the account in years.
#'   \item gender, boolean. Gender of the client.
#'   \item occupation, numeric. Occupation of the client.
#'   \item nationality, character. Country of birth of the client (labelled in ISO-CODE 2).
#'   \item residence, character. Country of residence of the client (labelled in ISO-CODE 2).
#'   \item pep_flag, boolean. Indicator whether the client is involved in political activities (1) or not (0).
#'   \item sar_flag, boolean. Indicator whether the client was involved in a reported transaction (1) or not (0).
#'   \item customer_id, character. ID of the client's account.
#' }
#'
#' @name clients_small_example
#' @usage data(clients_small_example)
#' @format A data frame with 20 rows and 9 variables
NULL
