% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rajive_helpfunctions.R
\name{showVarExplained_robust}
\alias{showVarExplained_robust}
\title{Proportions of variance explained}
\usage{
showVarExplained_robust(ajiveResults, blocks)
}
\arguments{
\item{ajiveResults}{List. The decomposition from Rajive}

\item{blocks}{List. The initial data blocks}
}
\value{
The proportion of variance explained by each component
}
\description{
Gets the variance explained by each component of the Rajive decomposition
}
\examples{
\donttest{
n <- 10
pks <- c(20, 10)
Y <- ajive.data.sim(K =2, rankJ = 2, rankA = c(7, 4), n = n,
                 pks = pks, dist.type = 1)
initial_signal_ranks <-  c(7, 4)
data.ajive <- list((Y$sim_data[[1]]), (Y$sim_data[[2]]))
ajive.results.robust <- Rajive(data.ajive, initial_signal_ranks)
showVarExplained_robust(ajive.results.robust, data.ajive)
}

}
