% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{subset_walks}
\alias{subset_walks}
\title{Subset Walks by Extreme Values}
\usage{
subset_walks(.data, .type = "max", .value = "y")
}
\arguments{
\item{.data}{A data frame containing random walks. It must have columns \code{walk_number} and the specified value column.}

\item{.type}{A character string specifying the type of subset: "max" for maximum value, "min" for minimum value, or "both" for both maximum and minimum values.}

\item{.value}{A character string specifying the column name to use for finding extreme values. Defaults to "y".}
}
\value{
A data frame containing the subset walk.
}
\description{
This function subsets random walks to identify the walk with the
maximum or minimum value.
}
\details{
The \code{subset_walks} function takes a data frame containing random
walks and subsets it to return the walk with the maximum or minimum value
based on the specified type. It requires that the input data frame contains
columns \code{walk_number} and the specified value column.
}
\examples{
set.seed(123)
df <- rw30()
subset_walks(df, .type = "max")
subset_walks(df, .type = "min")
subset_walks(df, .type = "both")

# Example with a specific value column
set.seed(123)
discrete_walk() |>
  subset_walks(.type = "both", .value = "cum_sum_y") |>
  visualize_walks(.pluck = 2)

}
\seealso{
Other Utility Functions: 
\code{\link{confidence_interval}()},
\code{\link{convert_snake_to_title_case}()},
\code{\link{generate_caption}()},
\code{\link{get_attributes}()},
\code{\link{rand_walk_column_names}()},
\code{\link{rand_walk_helper}()},
\code{\link{running_quantile}()},
\code{\link{std_cum_max_augment}()},
\code{\link{std_cum_mean_augment}()},
\code{\link{std_cum_min_augment}()},
\code{\link{std_cum_prod_augment}()},
\code{\link{std_cum_sum_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility Functions}
