% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankLN.R
\name{rankLN}
\alias{rankLN}
\title{Rank responses under the Bayesian framework according to
the loss function in Method 1 of Wang and Huang (2004).}
\usage{
rankLN(data, response.number, prior.parameter, c)
}
\arguments{
\item{data}{A m by n matrix \eqn{d_{ij}}, where \eqn{d_{ij}} = 0 or 1.
If the ith respondent selects the jth
response, then \eqn{d_{ij}} = 1, otherwise \eqn{d_{ij}} = 0.}

\item{response.number}{The number of the responses.}

\item{prior.parameter}{The parameter vector of the Dirichlet prior distribution
, where the vector dimension is 2^response.number.}

\item{c}{The value of c in the loss function}
}
\value{
The rankLN returns the estimated probabilities of the responses
being selected in the first line and the ranks of the responses in the second line.
}
\description{
Rank responses of a single response question or a multiple
response question under the Bayesian framework according to
the loss function in Method 1 of Wang and Huang (2004).
}
\examples{
set.seed(12345)
# This is an example to rank k responses in a multiple response question
# when the number of respondents is 1000 and the value e2R is 0.15.
# In this example, we do not use a real data, but generate data in the first six lines.
k <- 3
data <- matrix(NA, nrow = 1000, ncol = k)
for(i in 1:k){
  p <- runif(1)
  data[, i] <- sample(c(0, 1), 1000, p = c(p, 1-p), replace = TRUE)
}
## or upload the true data
response.number <- 3
prior.parameter <- c(5, 98, 63, 7, 42, 7, 7, 7)
c <- 0.05
rankLN(data, response.number, prior.parameter, c)

}
\references{
Wang, H. and Huang, W. H. (2014). Bayesian Ranking Responses in Multiple Response Questions.
            Journal of the Royal Statistical Society: Series A (Statistics in Society), 177, 191-208.
}
\seealso{
\code{\link{rankL2R}}, \code{\link{rank.wald}}, \code{\link{rank.gs}}
}
\author{
Hsiuying Wang \email{wang@stat.nycu.edu.tw}
, Yu-Chun Lin \email{restart79610@hotmail.com}
}
