#' Hubble Space Telescope Data
#'
#' Distances and velocities measured for 24 galaxies containing
#' Cepheid stars to measure the Hubble constant.
#'
#' @format 24 obs. of 3 variables:
#' \describe{
#' \item{Galaxy}{A label to identify the galaxy (a factor)}
#' \item{Velocity}{Relative velocity in kilometers per second}
#' \item{Distance}{Distance in Mega parsecs}
#' }
#' @source Freedman et al. 2001. The Astrophysical Journal 553:47-72: Tables 4 and 5.
#' @references
#'   Freedman et al. (2001) Final results from the Hubble space telescope key project to measure the Hubble constant. The Astrophysical Journal (553), 47-72.
#'   Wood, S.N. (2017) Generalized Additive Models: An Introduction with R. CRC
"hubble"

