% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_est.R
\name{get_est}
\alias{get_est}
\title{Make predictions with causalEGM model.}
\usage{
get_est(object, v, x = NULL)
}
\arguments{
\item{object}{An object of class \code{"causalegm"}.}

\item{v}{is the covariates, two-dimensional array with size n by p.}

\item{x}{is the optional treatment variable, one-dimensional array with size n. Defaults to NULL.}
}
\value{
Vector of predictions.
}
\description{
When x is NULL, the conditional average treatment effect (CATE), namely tau(v), is estimated using a trained causalEGM model.
When x is provided, estimating the potential outcome y given treatment x and covariates v using a trained causalEGM model.
}
\examples{
\donttest{
#Generate a simple simulation data.
n <- 1000
p <- 10
v <- matrix(rnorm(n * p), n, p)
x <- rbinom(n, 1, 0.4 + 0.2 * (v[, 1] > 0))
y <- pmax(v[, 1], 0) * x + v[, 2] + pmin(v[, 3], 0) + rnorm(n)
model <- causalegm(x=x, y=y, v=v, n_iter=3000)
n_test <- 100
v_test <- matrix(rnorm(n_test * p), n_test, p)
x_test <- rbinom(n_test, 1, 0.4 + 0.2 * (v_test[, 1] > 0))
pred_cate <- get_est(model, v = v_test) # CATE estimate
pred_y <- get_est(model, v = v_test, x = x_test) # y given treatment x plus covariates v
}
}
