\name{RcmdrPlugin.HH-package}
\alias{RcmdrPlugin.HH-package}
\alias{RcmdrPlugin.HH}
\docType{package}
\title{
Functions added to the Rcmdr package to support the introductory course
at Temple University.
}
\description{
  Our introductory course spends time on several topics that are not yet
  in the R Commander.  Therefore we wrote the menu items and make them
  available.
}
\details{
The DESCRIPTION file:
\packageDESCRIPTION{RcmdrPlugin.HH}
\packageIndices{RcmdrPlugin.HH}


\code{\link{bestSubsetsRegressionModel.HH}} Rcmdr interface to the
\code{\link[leaps]{regsubsets}} function in the \code{leaps} package.

\code{\link{twoWayTable.HH}} Pearson's Chi-squared Test for Count Data
(additional formats for data input)

\code{\link{anovaTableI.HH}} Sequential sums of squares on the Rcmdr menu.

\code{\link{scatter3dHH}} add the ability to plot squared residuals.
The squared residuals have been adopted into \code{Rcmdr}.  This
interface offers a checkbox for a new 3D window and an option to
draw a non-least-squares plane for pedagogical comparison.

\code{\link[HH]{ci.plot}} Plot confidence and prediction intervals for
simple linear regression.

\code{\link[HH]{panel.bwplot.intermediate.hh}} Panel function for \code{bwplot} that
  give the user control over the placement of the boxes.

\code{\link[HH]{interaction2wt}} Plot all main effects and twoway
interactions in a multifactor design.

\code{\link{scatterPlotMatrix.HH}} Similar to
\code{\link[car]{scatterplotMatrix}}
  The revision uses \code{row1attop=FALSE} to force the main diagonal of
  the scatterplot matrix to go uphill from southwest to northeast.

\code{\link{QQPlot.HH}}  Added Shapiro-Wilk test of normality.

\code{\link[HH]{norm.curve}} Plot a normal curve with shaded rejection regions,
optionally a second curve centered at an alternative hypothesis value
can be plotted.  Both \code{x} and \code{z} scales are displayed.

}

\author{
\packageAuthor{RcmdrPlugin.HH}

Maintainer: \packageMaintainer{RcmdrPlugin.HH}
}
\references{
Heiberger, Richard M. and Holland, Burt (2015).
\emph{Statistical Analysis and Data Display: An Intermediate Course with Examples in R}.
Second Edition.
Springer-Verlag, New York.
\url{https://link.springer.com/book/10.1007/978-1-4939-2122-5}

  Heiberger, Richard M. and Holland, Burt (2004).
\emph{Statistical Analysis and Data Display: An Intermediate Course
  with Examples in S-Plus, R, and SAS}, First Edition.
 Springer Texts in Statistics. Springer.
 \url{https://link.springer.com/book/10.1007/978-1-4757-4284-8}.
}
\keyword{ package }
\seealso{
\code{\link[Rcmdr:Rcmdr-package]{Rcmdr}}
}

\examples{
\dontrun{
   ## start R
   library(RcmdrPlugin.HH)        ## loads the package and opens the Rcmdr
                                  ## window with the HH menu
}
}
