% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqp.R
\name{matrix_to_subcorpus}
\alias{matrix_to_subcorpus}
\title{Create CWB subcorpus from matrix with regions.}
\usage{
matrix_to_subcorpus(region_matrix, corpus, subcorpus)
}
\arguments{
\item{region_matrix}{A two-colum \code{matrix} with regions in rows: Start
position of region in first column, end position in second column.}

\item{corpus}{A \code{externalptr} referencing a corpus such as generated by
\code{cl_find_corpus()}.}

\item{subcorpus}{A length-one \code{character} vector providing the name for the
subcorpus.}
}
\description{
Create CWB subcorpus from matrix with regions.
}
\examples{
\dontrun{
# First we generate a subcorpus from a query result
oil_context <- cqp_query("REUTERS", subcorpus = "OIL", query = '[]{3}"oil" []{3}')
m <- subcorpus_get_ranges(oil_context)
reuters <- cl_find_corpus("REUTERS", registry = get_tmp_registry())
p <- matrix_to_subcorpus(subcorpus = "OIL2", corpus = reuters, region_matrix = m)
cqp_list_subcorpora("REUTERS")

x <- cqp_query("REUTERS:OIL2", query = '"crude";', subcorpus = "CRUDEOIL")
subcorpus_get_ranges(x)

# clean up
cqp_drop_subcorpus("REUTERS:OIL")
cqp_drop_subcorpus("REUTERS:OIL2")
cqp_drop_subcorpus("REUTERS:CRUDEOIL")
}
}
