% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rddata.R
\name{rddata}
\alias{rddata}
\title{Download and Read Datasets from Rdatasets}
\usage{
rddata(dataset, package = NULL)
}
\arguments{
\item{dataset}{String. Name of the dataset to download from the Rdatasets archive. Use \code{rdsearch()} to search available datasets.}

\item{package}{String. Package name that originally published the data. If NULL, the function will attempt to automatically detect the package by searching for an exact match in the Rdatasets index.}
}
\value{
A data frame containing the dataset. The columns and rows vary based on the dataset.
}
\description{
Downloads a dataset from the Rdatasets archive and returns it as a data frame.

\url{https://vincentarelbundock.github.io/Rdatasets/}
}
\details{
If the \code{nanoparquet} package is installed, \code{rddata()} will use the
Parquet format, which is faster and uses less bandwidth to download. If
\code{nanoparquet} is not available, the function automatically falls back
to CSV format using base R functionality.
}
\section{Global Options}{

The following global options control package behavior:
\itemize{
\item \code{Rdatasets_cache}: Logical
\itemize{
\item Whether to cache downloaded data and index for faster subsequent access. Default: \code{TRUE}. Please keep this option TRUE as it makes repeated access faster and avoids overloading the Rdatasets server. Only set to FALSE if local memory is severely limited.
\item Ex: `options(Rdatasets_cache = TRUE)``
}
\item \code{Rdatasets_class}: String
\itemize{
\item Output class of the returned data. One of "data.frame" (default), "tibble", or "data.table". Default: \code{"data.frame"}. Requires the respective packages to be installed for "tibble" or "data.table" formats.
\item Ex: \code{options(Rdatasets_class = "tibble")}
}
\item \code{Rdataset_path}: String.
\itemize{
\item Base URL for the Rdatasets archive. Default: \code{"https://vincentarelbundock.github.io/Rdatasets/"}. Advanced users can set this to use a different mirror or local copy.
\item Ex: \code{options(Rdataset_path = "https://vincentarelbundock.github.io/Rdatasets/")}
}
}
}

\examples{
dat <- rddata("Titanic", "Stat2Data")
head(dat)
}
