#' Finding IC1 and IC2 from a distance matrix
#'
#' This function finds the IC1 and IC2 from a distance matrix. IC1 and IC2 are the closets and second closest cluster centers.
#'
#' @param Dist_e_cent Matrix. The position (i,j) contains the distance between the taxa i and the center j.
#'
#' @return Returns a matrix. The first column contain the IC1 and the second column contain the IC2.
#' @examples
#'
#'
#'dist=rbind(c(1,2,3),c(6,19,2),c(2,4,1),c(2,3,9))
#'Dist_IC1_IC2(dist)
#' @export
#'
#'
Dist_IC1_IC2<-function(Dist_e_cent){
  Matrizz=matrix(0, dim(Dist_e_cent)[1], 2)
  Dist_e_cent2=Dist_e_cent
  for(i in 1:(dim(Dist_e_cent)[1])){
    Matrizz[i,1]=which.min(Dist_e_cent[i,])

    Dist_e_cent2[i,Matrizz[i,1]]=max(Dist_e_cent[i,])+20
    Matrizz[i,2]=which.min(Dist_e_cent2[i,])

  }
  return(Matrizz)

}



