#' Relative Distance
#'
#' This function calculates the Relative Distance between two vectors.
#'
#' @param vect1 vector
#' @param vect2 vector
#'
#'
#'@returns A number with the distance between \code{vect1} and \code{vect2}.
#'
#'
#'@examples
#'
#'   RelativeDistance(c(1,2,3), c(4,5,6))
#'
#' @export





RelativeDistance<-function(vect1, vect2){


  comp1=vect1
  comp2=vect2

  dem=apply(data.frame(cbind(comp1,comp2)),1,max)
  num=abs(comp1-comp2)


  if(length(which(dem==0))!=0){
    zero=which(dem==0)
    for(i in 1:length(zero)){
      num[zero[i]]=0
      dem[zero[i]]=1
    }
  }

  dist=sum(num/dem)



  return(dist)
}
