#' Add values to a vector if they are not already in it
#'
#' This function adds two values to a vector if the values are not already in the vector.
#'
#' @param vector Vector with values
#' @param num1 Number. Value that will be added to the vector it it is no already in it.
#' @param num2 Number. Value that will be added to the vector it it is no already in it.
#'
#' @return Returns the vector with the values added if they are not alredy in the vector.
#'
#' @examples
#'mi_vector <- c(1, 2, 3, 4, 5)
#'num1 <- 8
#'num2 <- 10
#'
#'mi_vector <- add_unique_numbers(mi_vector, num1, num2)
#' @export
#'
#'


add_unique_numbers <- function(vector, num1, num2) {
  if (!(num1 %in% vector)) {
    vector <- c(vector, num1)
  }
  if (!(num2 %in% vector)) {
    vector <- c(vector, num2)
  }
  return(vector)
}
