% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECDentroCluster.R
\name{ECDentroCluster}
\alias{ECDentroCluster}
\title{Sum of squared errors within the cluster}
\usage{
ECDentroCluster(data, FHW_output, distance)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{FHW_output}{List. List with:

\itemize{
  \item centers: the information of the centers updated.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}
}
\value{
Returns a vector. The component i contains the sum of squared errors  value of group i.
}
\description{
The sum of squared errors within the cluster (also known as inertia) is calculated. We calculate the squared distance between the points that belong to a cluster and the cluster centroid. Then, we sum all the squared distances obtained. In this function the user can choose the distance that want to use to calculate the sum of squared errors within the cluster.
}
\examples{

set.seed(231)
data1=gtools::rdirichlet(10,c(1,1,1,4,4))
data=t(data1)
grouping=list(c(1,2,3),c(4,5))
centers=centers_function_mean(data, grouping)
FHW_output=list(centers=centers,   grouping=grouping)
distance=Euclideandistance

ECDentroCluster(data, FHW_output, distance)



}
