set.seed(231)
data1=gtools::rdirichlet(10,c(1,1,1,4,4))
data=t(data1)
grouping=list(c(1,2,3),c(4,5))
centers=centers_function_mean(data, grouping)


FHW_output=list(centers=centers,   grouping=grouping)
distance=Euclideandistance



G1=sum(distance(data[1,], centers[1,])+distance(data[2,], centers[1,])+distance(data[3,], centers[1,]))
G2=sum(distance(data[4,], centers[2,])+distance(data[5,], centers[2,]))

fin=c(G1,G2)
exp=ECDentroCluster3(data, FHW_output, distance)

test_that("ECDentroCluster3", {
  expect_equal(exp, fin, tolerance=1e-6)
})
