% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDep3.R
\name{joinToAvailablePackages}
\alias{joinToAvailablePackages}
\title{Join a data.table with a \code{Package} column to \code{available.packages}}
\usage{
joinToAvailablePackages(pkgDT, repos, type, which, verbose)
}
\arguments{
\item{pkgDT}{A \code{pkgDT} object e.g., from \code{toPkgDT}}

\item{repos}{is used for \code{ap}.}

\item{type}{See \code{utils::install.packages}}

\item{which}{a character vector listing the types of dependencies, a subset
of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector, character string
\code{"most"} for the same vector without \code{"Enhances"}.}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}
}
\value{
The returned \code{data.table} will have most of the columns from
\code{available.packages} appended to the \code{pkgDT}, including \code{Depends}, \code{Imports},
\code{Suggests}. It will change the column name that is normally
returned from \code{available.packages} as \code{Version} to \code{VersionOnRepos}.
}
\description{
Will join \code{available.packages()} with \code{pkgDT}, if \code{pkgDT} does not already have
a column named \code{Depends}, which would be an indicator that this had already
happened.
}
