% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individualplot.fn.R
\name{Individualplot.fn}
\alias{Individualplot.fn}
\title{Function to plot multiscale entropy or MFDFA results by individual.}
\usage{
Individualplot.fn(
  x,
  y,
  Name = NA,
  xRange = NA,
  yRange = NA,
  col = NA,
  pch = NA,
  Position = "topright",
  cex.legend = 0.75,
  xlab = "",
  ylab = "",
  main = ""
)
}
\arguments{
\item{x}{a vector for x-axis coordinate.}

\item{y}{Matrix for response values.}

\item{Name}{vector of names for each line.}

\item{xRange}{range for the x-axis.}

\item{yRange}{range for the y-axis.}

\item{col}{vector for the colors to indicate groups.}

\item{pch}{vector for points types to indicate groups.}

\item{Position}{position for the legend.}

\item{cex.legend}{cex for legend.}

\item{xlab}{a title for x axis.}

\item{ylab}{a title for y axis.}

\item{main}{main title for the picture.}
}
\value{
No value returned
}
\description{
function to plot multiscale entropy or MFDFA results by individual.
}
\examples{
data("HqData")
PP_Hq <- HqData
filenames <- row.names(PP_Hq)
q=-10:10
ClassNames <- c(substr(filenames[1:19], start = 1, stop = 3),
                substr(filenames[20:38], start = 1, stop = 5))
Class <- unique(ClassNames)
col_vec <- rep(NA, nrow(PP_Hq) )
pch_vec <- rep(16, nrow(PP_Hq) )
for( i in 1:length(Class) ) { col_vec[ ClassNames == Class[i] ] <- i }
Individualplot.fn(q,PP_Hq,Name=Class,col=col_vec,pch=pch_vec, xlab="q",ylab="Hurst exponent")
legend("topright", legend=paste0(Class, "(N=", table( ClassNames ), ")"),
      col=1:4, cex=1, lty=1, pch=16)

}
\references{
Zhang T, Dong X, Chen C, Wang D, Zhang XD. RespirAnalyzer: an R package for continuous monitoring of respiratory signals.
}
