% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFDFAplot.fn.R
\name{MFDFAplot.fn}
\alias{MFDFAplot.fn}
\title{Function to plot the results of MFDFA analysis}
\usage{
MFDFAplot.fn(
  Result,
  scale,
  q,
  cex.lab = 1.6,
  cex.axis = 1.6,
  col.points = 1,
  col.line = 1,
  lty = 1,
  pch = 16,
  lwd = 2,
  model = TRUE,
  cex.legend = 1
)
}
\arguments{
\item{Result}{a list of the MFDFA results.}

\item{scale}{a vector of scales used to calculate the MFDFA results.}

\item{q}{a vector, q-order of the moment used to calculate the MFDFA results.}

\item{cex.lab}{the size of the tick label numbers/text with a numeric value of length 1.The default value is 1.6.}

\item{cex.axis}{the size of the axis label text with a numeric value of length 1.The default value is 1.6.}

\item{col.points}{color of the and point.}

\item{col.line}{color of the line}

\item{lty}{line types.}

\item{pch}{points types.}

\item{lwd}{line width.}

\item{model}{whether to use the model to fit the results and draw a line of fit.}

\item{cex.legend}{the size of the legend text with a numeric value of length 1.The default value is 1.}
}
\value{
No value returned
}
\description{
function to plot the results of MFDFA analysis: q-orde
fluctuation function, Hurst exponent,mass exponent and multifractal
spectrum. The fitting result of binomial multifratcal model can be also
shown by the fitting line
}
\examples{
data("TestData")
Fs=50 ## sampling frequency is 50Hz
Peaks <- find.peaks(Data[,2],Fs,lowpass=TRUE,freq=1,MovingAv=FALSE,
                    W=FALSE,filter=TRUE,threshold=0.05)
PP_interval=diff(Peaks[,1])/Fs
exponents=seq(3, 9, by=1/4)
scale=2^exponents
q=-10:10
m=2
Result <- MFDFA(PP_interval, scale, m, q)
MFDFAplot.fn(Result,scale,q)

}
\references{
Zhang T, Dong X, Chen C, Wang D, Zhang XD. RespirAnalyzer: an R package for continuous monitoring of respiratory signals.
}
