% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit.fuzzycoco_model}
\alias{fit.fuzzycoco_model}
\title{fit the FuzzyCoco model using the formula interface}
\usage{
\method{fit}{fuzzycoco_model}(
  object,
  formula,
  data,
  engine = FUZZY_COCO_HYBRID_ENGINE,
  max_generations = object$params$global_params$max_generations,
  max_fitness = object$params$global_params$max_fitness,
  seed = object$seed,
  verbose = object$verbose,
  ...
)
}
\arguments{
\item{object}{the \emph{fuzzycoco_model} object to fit}

\item{formula}{the fuzzy coco model as a formula}

\item{data}{the data to fit as a data frame.  The output variables must be grouped AFTER the input variables}

\item{engine}{the fuzzy coco fit engine to use, one of \strong{rcpp} and \strong{hybrid}}

\item{max_generations}{The maximum number of iterations of the algorithm.
Each iteration produces a new generation of the rules and membership functions populations.}

\item{max_fitness}{a stop condition: the iterations stop as soon as a generated fuzzy system fitness
reaches that threshold.}

\item{seed}{the RNG seed to use (to fit the model)}

\item{verbose}{whether to be verbose}

\item{...}{
  Arguments passed on to \code{\link[=fit_xy.fuzzycoco_model]{fit_xy.fuzzycoco_model}}
  \describe{
    \item{\code{x}}{the input variables data (usually to fit) as a dataframe}
    \item{\code{y}}{the output variables data (usually to fit)  as a dataframe}
  }}
}
\value{
the fit as a named list
}
\description{
N.B: \code{fix_xy()} is the workhorse, \code{fit()} is a simple formula-based layer
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
df <- mtcars[c("mpg", "hp", "wt", "qsec")]
fit <- fit(model, qsec ~ ., df, seed = 456, max_generations = 10, progress = FALSE)
print(names(fit))

}
