% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{plot_mda}
\alias{plot_mda}
\title{Plot the estimated MDA impact function}
\usage{
plot_mda(
  object,
  mda_history = NULL,
  n_sim = 1000,
  x_min = 1e-06,
  x_max = 10,
  conf_level = 0.95,
  lower_f = NULL,
  upper_f = NULL,
  mc_cores = 1,
  parallel_backend = c("none", "fork", "psock"),
  ...
)
}
\arguments{
\item{object}{A fitted DAST model object, returned by \code{\link{dast}}.}

\item{mda_history}{Specification of the MDA schedule. This can be either:
\itemize{
  \item A numeric vector of event times (integers starting at 0, e.g. \code{c(0,1,2,6)}),
  \item OR a 0/1 indicator vector on the yearly grid (e.g. \code{c(1,1,1,0,0,0,1)}),
  where position \code{i} corresponds to year \code{i-1}.
}
If omitted, the default is a single MDA at time 0.}

\item{n_sim}{Number of posterior draws used for uncertainty quantification (default: 1000).}

\item{x_min}{Minimum value for the x-axis (default: \code{1e-6}).}

\item{x_max}{Maximum value for the x-axis (default: \code{10}).}

\item{conf_level}{Confidence level for the pointwise uncertainty interval (default: 0.95).}

\item{lower_f}{Optional lower bound for the y-axis. If not provided, computed from the data.}

\item{upper_f}{Optional upper bound for the y-axis. If not provided, computed from the data.}

\item{mc_cores}{Number of CPU cores to use for parallel simulation. Default is 1 (serial).}

\item{parallel_backend}{Parallelisation backend to use. Options are \code{"none"} (default),
\code{"fork"} (Unix-like systems), or \code{"psock"} (cross-platform).}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{ggplot2} object showing the median estimated MDA impact function
and the pointwise uncertainty band at the chosen confidence level.
}
\description{
Generate a plot of the estimated impact of mass drug administration (MDA)
on infection prevalence, based on a fitted decay-adjusted spatio-temporal (DAST) model.
The function simulates draws from the posterior distribution of model parameters,
propagates them through the MDA effect function, and produces uncertainty bands
around the estimated impact curve.
}
\details{
The time axis is assumed to start at 0 and increase in integer steps of 1 year.
The argument \code{mda_history} allows the user to specify when MDAs occurred either
by listing the years directly or by giving a binary indicator on the yearly grid.
The function then evaluates the cumulative relative reduction
\eqn{1 - \mathrm{effect}(t)} at a dense grid of time points between \code{x_min}
and \code{x_max}, using the fitted parameters from the supplied DAST model.
}
