% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submitGroupPost.R
\name{submitGroupPost}
\alias{submitGroupPost}
\title{Create a Group Discussion Post}
\usage{
submitGroupPost(token, group_id, disc_title = NULL, disc_summary = NULL,
  content_title = NULL, content_url = NULL, content_img = NULL,
  content_desc = NULL, partner = 0)
}
\arguments{
\item{token}{Authorization token.}

\item{group_id}{Numeric Group ID.}

\item{disc_title}{Group discussion title, required.}

\item{disc_summary}{Group discussion summary, required.}

\item{content_title}{Title for content, required.}

\item{content_url}{Url for content, optional.}

\item{content_img}{Url for an image, optional.}

\item{content_desc}{Description of content, optional.}

\item{partner}{Indicate whether you belong to the Partnership Program. Values: 0 or 1}
}
\value{
There are two possible responses to a successful submittal. 

One, your post has been created and is visibile immediately. In this case you have most likely posted to an unmoderated group. 

Two, your post has been accepted by the API but is pending approval by the group moderator, in which case you will not see your post until it has bene approved.
}
\description{
\code{submitGroupPost} will create a group discussion post in one of the
groups you belong to, specified by a Group Id.
}
\details{
You must include a minimum of a discussion title, discussion summary, and content title.
}
\examples{
\dontrun{

my.groups <- getGroups(in.auth)

id <- my.groups$group_id[1]
disc.title <- "Test connecting to the LinkedIn API via R"
disc.summary <- "Im creating an R package to connect to the LinkedIn API, 
                 + this is a test post from R!"
url <- "https://github.com/mpiccirilli"
content.desc <- "Dev version of access to LinkedIn API via R. 
                              + Collaboration is welcomed!"

submitGroupPost(in.auth, group_id=id, disc_title=disc.title, 
disc_summary=disc.summary, content_url=url, content_desc=content.desc)
}
}
\author{
Michael Piccirilli \email{michael.r.piccirilli@gmail.com}
}
\seealso{
\code{\link{getGroups}} \code{\link{getGroupPosts}}
}

