% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCML.R
\name{MMPY}
\alias{MMPY}
\title{MM regression estimator using Pen~a-Yohai candidates}
\usage{
MMPY(X, y, control, mf)
}
\arguments{
\item{X}{design matrix}

\item{y}{response vector}

\item{control}{a list of control parameters as returned by \code{\link{lmrobdet.control}}}

\item{mf}{model frame}
}
\value{
an \code{lmrob} object witht the M-estimator
obtained starting from the S-estimator computed with the
Pen~a-Yohai initial candidates. The properties of the final
estimator (efficiency, etc.) are determined by the tuning constants in
the argument \code{control}.
}
\description{
This function computes MM-regression estimator using Pen~a-Yohai
candidates for the initial S-estimator. This function is used
internally by \code{\link{lmrobdetMM}}, and not meant to be used
directly.
}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{DCML}}, \code{\link{MMPY}}, \code{\link{SMPY}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}, Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
