% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCML.R
\name{scaleM}
\alias{scaleM}
\title{M-scale estimator}
\usage{
scaleM(
  u,
  delta = 0.5,
  family = "bisquare",
  max.it = 100,
  tol = 1e-06,
  tolerancezero = .Machine$double.eps,
  tuning.chi = lmrobdet.control(family = family, bb = delta)$tuning.chi
)
}
\arguments{
\item{u}{vector of residuals}

\item{delta}{the right hand side of the M-scale equation}

\item{family}{string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "opt" and "mopt").}

\item{max.it}{maximum number of iterations allowed}

\item{tol}{relative tolerance for convergence}

\item{tolerancezero}{smallest (in absolute value) non-zero value accepted as a scale. Defaults to \code{.Machine$double.eps}}

\item{tuning.chi}{the tuning object as returned
by \code{\link{lmrobdet.control}}, \code{\link{bisquare}}, \code{\link{mopt}},
or \code{\link{opt}}. It defaults to the value that results
in a consistent scale estimator for the specified \code{family} 
of loss functions and breakdown point as set by \code{delta}.}
}
\value{
The scale estimate value at the last iteration or at convergence.
}
\description{
This function computes an M-scale, which is a robust
scale (spread) estimator.
M-estimators of scale are a robust alternative to
the sample standard deviation. Given a vector of
residuals \code{r}, the M-scale estimator \code{s}
solves the non-linear equation \code{mean(rho(r/s, cc))=delta},
where \code{delta} determines the breakdown point of the 
estimator, and \code{cc} is a tuning parameter 
calculated to obtain consistency under a Gaussian model. 
The breakdown point of the estimator is \code{min(delta, 1-delta)},
so the optimal choice for \code{delta} is 0.5. To obtain a
consistent estimator the constant
\code{cc} is chosen such that E(rho(Z, cc)) = delta, where
Z is a standard normal random variable.
}
\details{
The iterative algorithm starts from the scaled median of
the absolute values of the input vector, and then
cycles through the equation \code{s^2 = s^2 * mean(rho(r/s, cc)) / delta}.
}
\examples{
set.seed(123)
r <- rnorm(150, sd=1.5)
scaleM(r)
sd(r)
# 10\% of outliers, sd of good points is 1.5
set.seed(123)
r2 <- c(rnorm(135, sd=1.5), rnorm(15, mean=-5, sd=.5))
scaleM(r2, family='opt')
sd(r2)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
