% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-calibrate.R
\name{robincar_calibrate}
\alias{robincar_calibrate}
\title{Perform linear or joint calibration}
\usage{
robincar_calibrate(result, joint = FALSE, add_x = NULL)
}
\arguments{
\item{result}{A GLMModelResult}

\item{joint}{If true, then performs joint calibration
with the \eqn{\hat{\bm \mu}(X_i)} and strata \eqn{Z_i}
to achieve universality and efficiency gain
rather than just linear calibration that uses \eqn{\hat{\bm \mu}(X_i)}.}

\item{add_x}{Additional x to use in the calibration. Must have been in
the original dataset that robincar_glm was called on.}
}
\value{
A result object that has the same structure as \link[RobinCar:robincar_glm]{RobinCar::robincar_glm()}, with the argument `result` included as "original" in the list.
}
\description{
Uses linear or joint calibration to "calibrate" the estimates from a linear or GLM-type adjustment.
Linear calibration fits a linear model with treatment (and treatment-by-covariate interactions) and with the predicted \eqn{\hat{\bm \mu}(X_i) = (\hat{\mu}_1(X_i), \dots, \hat{\mu}_K(X_i))} as constructed covariates where \eqn{K} is the number of treatment groups;
joint calibration also includes \eqn{Z_i} the strata variables as covariates.
}
