% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skelPxWidth.R
\name{skelPxWidth}
\alias{skelPxWidth}
\title{Count skeleton root pixels with certain widths in the base root image}
\usage{
skelPxWidth(base_img, skel_img, mask = NULL)
}
\arguments{
\item{base_img}{Base image (provided by the RootDetector). Can be a PNG,
i.e., an array with 3 dimensions (3 layers each containing a 2-dim. numeric
matrix with values between 0 and 1), or a 2-dim. matrix.}

\item{skel_img}{Skeleton image with the same number of rows and columns
as \code{base_img} (provided by the RootDetector). Can be a PNG,
i.e., an array with 3 dimensions (3 layers each containing a 2-dim. numeric
matrix with values between 0 and 1), or a 2-dim. matrix.}

\item{mask}{2-dim. true/false-matrix with the same number of rows and columns
as \code{base_img} (optional, default = NULL, interpreted as a matrix
consisting only of TRUEs, i.e., nothing is "removed" from the image).}
}
\value{
\code{skelPxWidth} Numeric vector of length 3 containing the counts.
}
\description{
\code{skelPxWidth} - Counts the skeleton pixels that belong to root pieces
of certain (circular) widths (diameter <3px, 3-7px, >7px).\cr
For each white root pixel in the skeleton image, it checks how large (in
terms of the categories <3px, 3-7px, >7px, which equal a radius of <1px,
1-3px, >=4px) the circle of white root pixels is that surrounds it in the
base root image. \cr
Optionally, a masking layer can be specified that indicates which pixels of
the skeleton image should be checked (the radius of the white circle is
still check in the complete base image).
}
\examples{
# In this example there are 2 white root pixels in the skeleton image.
# The left one is completely surrounded by white pixels in the base image,
# it falls into Category 2 (3-7px). The bottom right one has a black
# neighboring pixel and thus falls in to Category 1 (<3px). Thus, the result
# is Categorie 1: 1 pixel, Cat. 2: 1 pixel, Cat. 3: 0 pixels.
skelPxWidth(base_img = matrix(c(1,1,1,0,
                     1,1,1,0,
                     1,1,1,1), ncol = 4, nrow = 3, byrow = TRUE),
            skel_img = matrix(c(0,0,0,0,
                     0,1,0,0,
                     0,0,0,1), ncol = 4, nrow = 3, byrow = TRUE))
# Similar example with a mask which makes the function "ignore" the right
# side of the skeleton image.
# The function still identifies the left white pixel as of Category 2.
skelPxWidth(matrix(c(1,1,1,0,
                     1,1,1,0,
                     1,1,1,1), ncol = 4, nrow = 3, byrow = TRUE),
            matrix(c(0,0,0,0,
                     0,1,0,0,
                     0,0,0,1), ncol = 4, nrow = 3, byrow = TRUE),
             matrix(c(TRUE,TRUE,FALSE,FALSE,
                      TRUE,TRUE,FALSE,FALSE,
                      TRUE,TRUE,FALSE,FALSE), ncol = 4, nrow = 3,
                      byrow = TRUE))
}
