% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centres.roll.R
\name{centres.ppRoll}
\alias{centres.ppRoll}
\alias{centres.ppRoll.default}
\alias{centres.ppRoll.atoms}
\alias{centres.ppRoll.pdb}
\title{Centres-of-Geometry: Rolling Window}
\usage{
\method{centres}{ppRoll}(x, window, ...)

\method{centres.ppRoll}{default}(x, window = 34, na.rm = TRUE, ...)

\method{centres.ppRoll}{atoms}(x, window = 34, chain = NULL, na.rm = TRUE, ...)

\method{centres.ppRoll}{pdb}(x, window = 34, chain = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{x}{an R object containing atomic coordinates (with additional class \code{ppRoll}).}

\item{window}{size of the rolling window, specified as number of amino-acids;}

\item{\dots}{further arguments passed to or from other methods.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{chain}{apply only to the respective chains, by default all chains;}
}
\value{
Return an object of class \sQuote{coords} containing the coordinates
  of the centres.
}
\description{
Computes the geometric centres using a rolling window on a polypeptide chain
}
\details{
\sQuote{centres.ppRoll} is a generic function to compute the geometric centres
using a rolling window on an object containing atomic coordinates for
a polypeptide chain. Due to limitations by CRAN check, the function is further
referred as \sQuote{centres}.

The function may be useful to visualize the overall protein structure,
but in a less cluttered way. Unlike the protein backbone, the centres
may capture better the bulk of the protein.
}
\examples{
### Example 1: Toll-Like Receptor 2
# Download pdb file for TLR2: 2Z81;
# Read the pdb-file:
# x = read.pdb("pdb2z81.ent")

# Compute the centres:
# tmp = centres.ppRoll(x)

# Visualize the structure:
# visualize(x, type="p", pbc.box = FALSE)
# lines3d(tmp, lwd = 5, col = "red")

# Add Another "strand":
# tmp = centres.ppRoll(x, window = 8)
# lines3d(tmp, lwd = 5, col = "#FA3296")
}
\seealso{
\code{\link{coords}}, \code{\link{atoms}}, \code{\link{pdb}}.
}
