% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB-package.R
\docType{package}
\name{RprobitB-package}
\alias{RprobitB}
\alias{RprobitB-package}
\title{RprobitB: Bayesian Probit Choice Modeling}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Bayes estimation of probit choice models in cross-sectional and panel settings. The package can analyze binary, multivariate, ordered, and ranked choices, as well as heterogeneity of choice behavior among deciders. The main functionality includes model fitting via Gibbs sampling, tools for convergence diagnostic, choice data simulation, in-sample and out-of-sample choice prediction, and model selection using information criteria and Bayes factors. The latent class model extension facilitates preference-based decider classification, where the number of latent classes can be inferred via the Dirichlet process or a weight-based updating heuristic. This allows for flexible modeling of choice behavior without the need to impose structural constraints. For a reference on the method, see Oelschlaeger and Bauer (2021) \url{https://trid.trb.org/view/1759753}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://loelschlaeger.de/RprobitB/}
  \item \url{https://github.com/loelschlaeger/RprobitB}
  \item Report bugs at \url{https://github.com/loelschlaeger/RprobitB/issues}
}

}
\author{
\strong{Maintainer}: Lennart Oelschläger \email{oelschlaeger.lennart@gmail.com} (\href{https://orcid.org/0000-0001-5421-9313}{ORCID})

Other contributors:
\itemize{
  \item Dietmar Bauer \email{dietmar.bauer@uni-bielefeld.de} (\href{https://orcid.org/0000-0003-2920-7032}{ORCID}) [contributor]
}

}
\keyword{internal}
