\name{Rquake-package}
\alias{Rquake-package}
\alias{Rquake}
\docType{package}
\title{
Seismic Analysis of Earthquake Hypocenter determination
}
\description{
  Non-linear earthquake locations are estimated
  by sequential convergence to
  hypocenter solutions, along with error ellipsoids and
  3D-plotting, using a
coordination of functions  from 'RSEIS', 'GEOmap', 'RFOC'
and others for a complete seismic analysis
from field campaign data or data extracted from online websites.
Interactive codes for seismic phase picking can be combined with
event location to go from raw seismic time series to earthquake analysis
and spatial statistics.
}
\details{

Rquake is a package for analaysis of seismic data 
collected continuously, or in trigger mode.
The functions organize other functions from
'RSEIS' and 'GEOmap' to help researchers 
pick, locate, and store hypocenters
for detailed seismic investigation.
}
\author{
Jonathan M. Lees<jonathan.lees.edu>
Maintainer:Jonathan M. Lees<jonathan.lees.edu>
}

\note{
  \describe{ 
    \item{Functions}{
CONTPF
EQXYresid
INITpickfile
NLSlocate
PFoutput
RQ
SavePF
UPdateEQLOC
XYSETUP
Y2Pphase
chak
contPFarrivals
doAmap
gMAP
getregionals
prepPDE
viewCHAC
  }
}}

\references{
Lee, W.H.K., and S.W. Stewart, Principles and Applications of Microearthquake Networks, Academic Press, New York, 1981.

}

\keyword{ package }
\seealso{
\code{\link[RSEIS:RSEIS-package]{RSEIS}}
}
\examples{


library(RSEIS)
data(GH, package='RSEIS')

g1 = GH$pickfile

data(VELMOD1D, package='RSEIS')
vel= VELMOD1D

 w1 = which(!is.na(g1$STAS$lat))
         sec = g1$STAS$sec[w1]

         N = length(sec)
         Ldat =    list(
           name = g1$STAS$name[w1],
           sec = g1$STAS$sec[w1],
           phase = g1$STAS$phase[w1],
           lat=g1$STAS$lat[w1],
           lon = g1$STAS$lon[w1],
           z = g1$STAS$z[w1],
           err= g1$STAS$err[w1],
           yr = rep(g1$LOC$yr , times=N),
           jd = rep(g1$LOC$jd, times=N),
           mo = rep(g1$LOC$mo, times=N),
           dom = rep(g1$LOC$dom, times=N),
           hr =rep( g1$LOC$hr, times=N),
           mi = rep(g1$LOC$mi, times=N) )


wstart = which.min(Ldat$sec)
        EQ = list(lat=Ldat$lat[wstart], lon=Ldat$lon[wstart], z=6, t=Ldat$sec[wstart] )
      

  AQ = Vlocate(Ldat,EQ,vel, 
      distwt = 10,
      lambdareg =100 ,
      REG = TRUE,
      WTS = TRUE,
      STOPPING = TRUE,
      tolx =   0.01,
      toly = 0.01 ,
      tolz = 0.05, maxITER = c(7,5,7,4) , RESMAX = c(0.1, 0.1),  PLOT=FALSE)



}
