% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{Rule6}
\alias{Rule6}
\title{Rule 6}
\usage{
Rule6(x, zoneB, minNPoints = 4, nPoints = 5, ...)
}
\arguments{
\item{x}{Numerical vector}

\item{zoneB}{Vector of zone borders}

\item{minNPoints}{Minimal number of points in a sequence violating a rule}

\item{nPoints}{Sequence of consequtive points to be evaluated}

\item{...}{unspecified arguments of a function}
}
\value{
Vector of the same length as x
}
\description{
Four or five out of five points in a row are more than 1 standard deviation from the mean in the same direction.
}
\details{
0 means: ok \cr
1 means: violation \cr

inequality used during evaluation
Rule is violated also if the first four points are beyond the 1 standard deviation from the mean
During calculation of EvaluateRules function wiht controlLimitDistance <= 1, the evaluation of this rule is suppressed
}
\examples{
limits = CalculateLimits(x = rnorm(10), lcl = NA, cl = 100, ucl = NA, type = 'i')
zones = CalculateZoneBorders(limits)
Rule6(x = rnorm(20), zoneB = zones, minNPoints = 4, nPoints = 5)
#zones is object created by function CalculateZoneBorders()
}
